<?php

//エラー出力
error_log("callback start.");

//設定ファイル参照
require_once('config.php');


//==========================
// メッセージ受信処理
//==========================
$json_string = file_get_contents('php://input');
$json_object = json_decode($json_string);
$content = $json_object->result{0}->content;
$text = $content->text;
$from = $content->from;
$message_id = $content->id;
$content_type = $content->contentType;

# ユーザ情報取得
api_get_user_profile_request($from);

# 相手からのメッセが画像、動画、音声であれば保存
if (in_array($content_type, array(2, 3, 4))) {
    api_get_message_content_request($message_id);
}


//==========================
// 返答する内容生成
//==========================
# テキストが送られた時
$rule_content = <<< EOM
        "contentType":1,
        "text":"{$rule}"
EOM;
$image_content = <<< EOM
        "contentType":2,
        "originalContentUrl":"{$original_content_url_for_image}",
        "previewImageUrl":"{$preview_image_url_for_image}"
EOM;
$video_content = <<< EOM
        "contentType":3,
        "originalContentUrl":"{$original_content_url_for_video}",
        "previewImageUrl":"{$preview_image_url_for_video}"
EOM;
$location_content = <<< EOM
        "contentType":7,
        "text":"Convention center",
        "location":{
        "title":"{$original_content_location_name}",
        "latitude":"{$original_content_location_latitude}",
        "longitude":"{$original_content_location_longitude}"
        }
EOM;

# テキスト以外が送られた時
$image_content_msg = <<< EOM
        "contentType":1,
        "text":"{$get_image}"
EOM;
$video_content_msg = <<< EOM
        "contentType":1,
        "text":"{$get_video}"
EOM;
$audio_content_msg = <<< EOM
        "contentType":1,
        "text":"{$get_audio}"
EOM;
$location_content_msg = <<< EOM
        "contentType":1,
        "text":"{$get_location}"
EOM;
$stamp_content_msg = <<< EOM
        "contentType":1,
        "text":"{$get_stamp}"
EOM;


//==========================
// 相手からのメッセに応じての返答パターン
//==========================
$event_type = "138311608800106203"; /* これは固有値（変更不可） */
if ($text == "遊び方") {
    $content = $rule_content;
} else if ($text == "画像") {
    $content = $image_content;
} else if ($text == "動画") {
    $content = $video_content;
} else if ($text == "位置") {
    $content = $location_content;
} else if ($text == "全部") {
    $event_type = "140177271400161403"; /* これは固有値（変更不可） */
$content = <<< EOM
    "messageNotified": 0,
    "messages": [
        {{$image_content}},
        {{$video_content}},
        {{$location_content}}
    ]
EOM;
} else {
$content = <<< EOM
        "contentType":1,
        "text":"{$get_message_before}{$text}{$get_message_after}\\n\\n\\n\\n※「遊び方」と話かけると、遊び方の説明が出ます！"
EOM;
if ($content_type == 2) {
	$content = $image_content_msg;
} else if ($content_type == 3) {
	$content = $video_content_msg;
} else if ($content_type == 4) {
	$content = $audio_content_msg;
} else if ($content_type == 7) {
	$content = $location_content_msg;
} else if ($content_type == 8) {
	$content = $stamp_content_msg;
}
}


//==========================
// 送信処理
//==========================
$post = <<< EOM
{
    "to":["{$from}"],
    "toChannel":1383378250,
    "eventType":"{$event_type}",
    "content":{
        "toType":1,
        {$content}
    }
}
EOM;

api_post_request("/v1/events", $post);

error_log("callback end.");

function api_post_request($path, $post) {

    $url = "https://trialbot-api.line.me{$path}";
    $headers = array(
        "Content-Type: application/json",
        "X-Line-ChannelID: {$GLOBALS['channel_id']}",
        "X-Line-ChannelSecret: {$GLOBALS['channel_secret']}",
        "X-Line-Trusted-User-With-ACL: {$GLOBALS['mid']}"
    );

    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $output = curl_exec($curl);
    error_log($output);
}

function api_get_user_profile_request($mid) {
    $url = "https://trialbot-api.line.me/v1/profiles?mids={$mid}";
    $headers = array(
        "X-Line-ChannelID: {$GLOBALS['channel_id']}",
        "X-Line-ChannelSecret: {$GLOBALS['channel_secret']}",
        "X-Line-Trusted-User-With-ACL: {$GLOBALS['mid']}"
    ); 

    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $output = curl_exec($curl);
    error_log($output);
}

function api_get_message_content_request($message_id) {
    $url = "https://trialbot-api.line.me/v1/bot/message/{$message_id}/content";
    $headers = array(
        "X-Line-ChannelID: {$GLOBALS['channel_id']}",
        "X-Line-ChannelSecret: {$GLOBALS['channel_secret']}",
        "X-Line-Trusted-User-With-ACL: {$GLOBALS['mid']}"
    ); 

    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $output = curl_exec($curl);
    file_put_contents("/tmp/{$message_id}", $output);
}